/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.gui.huts.WindowBarracksBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final String TAG_TOWERS = "towers";
    private final List<BlockPos> towers = new ArrayList<BlockPos>();
    public static int SPIES_GOLD_COST = 5;

    public BuildingBarracks(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(stack -> stack.func_77973_b() == Items.field_151043_k, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (BlockPos tower : this.towers) {
                world.func_175656_a(tower, Blocks.field_150350_a.func_176223_P());
            }
        }
        super.onDestroyed();
        this.colony.getBuildingManager().guardBuildingChangedAt(this, 0);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.colony.getBuildingManager().guardBuildingChangedAt(this, newLevel);
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState block, @NotNull BlockPos pos, @NotNull World world) {
        IBuilding building;
        super.registerBlockPosition(block, pos, world);
        if (block.func_177230_c() == ModBlocks.blockHutBarracksTower && (building = this.getColony().getBuildingManager().getBuilding(pos)) instanceof BuildingBarracksTower) {
            building.setStyle(this.getStyle());
            ((BuildingBarracksTower)building).addBarracks(this.getPosition());
            if (!this.towers.contains(pos)) {
                this.towers.add(pos);
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (colony.getWorld().field_72995_K) {
            return;
        }
        if (colony.getRaiderManager().isRaided()) {
            if (!colony.getRaiderManager().areSpiesEnabled() && InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), new ItemStack((IItemProvider)Items.field_151043_k, SPIES_GOLD_COST))) {
                colony.getRaiderManager().setSpiesEnabled(true);
                colony.markDirty();
            }
        } else {
            colony.getRaiderManager().setSpiesEnabled(false);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        if (newLevel <= 0) {
            return 0;
        }
        int barracksClaimRadius = 3;
        for (BlockPos pos : this.towers) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
            if (building == null || building.getBuildingLevel() >= 4) continue;
            barracksClaimRadius = 2;
            break;
        }
        return barracksClaimRadius;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.barracks;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.towers.clear();
        this.towers.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_TOWERS, 10)).map(resultCompound -> BlockPosUtil.read(resultCompound, "pos")).collect(Collectors.toList()));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT towerTagList = this.towers.stream().map(pos -> BlockPosUtil.write(new CompoundNBT(), "pos", pos)).collect(NBTUtils.toListNBT());
        compound.func_218657_a(TAG_TOWERS, (INBT)towerTagList);
        return compound;
    }

    public List<BlockPos> getTowers() {
        return this.towers;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

